/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WeaselEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(WeaselEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(WeaselEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.m_135353_(WeaselEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SNOWY_VARIANT = SynchedEntityData.m_135353_(WeaselEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean orderedToSit;
    private boolean hasBittenPlayer = false;
    private long lastDigTime = 0L;
    public static final float DEFAULT_HEALTH = 8.0f;
    public static final float TAMED_HEALTH = 20.0f;

    public WeaselEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        if (this.m_21824_()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
            this.m_21153_(8.0f);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (this.isInSnowyBiome()) {
            this.setSnowVariant(true);
        } else {
            this.setSnowVariant(false);
        }
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DIGGING, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(SNOWY_VARIANT, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("IsSnowVariant", ((Boolean)this.f_19804_.m_135370_(SNOWY_VARIANT)).booleanValue());
        tag.m_128379_("Sleeping", this.m_5803_());
        tag.m_128379_("Sitting", this.orderedToSit);
        tag.m_128347_("PosX", this.m_20185_());
        tag.m_128347_("PosY", this.m_20186_());
        tag.m_128347_("PosZ", this.m_20189_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.f_19804_.m_135381_(SNOWY_VARIANT, (Object)tag.m_128471_("IsSnowVariant"));
        this.orderedToSit = tag.m_128471_("Sitting");
        this.setSleeping(tag.m_128471_("Sleeping"));
        this.m_21837_(this.orderedToSit);
        if (tag.m_128441_("PosX") && tag.m_128441_("PosY") && tag.m_128441_("PosZ")) {
            double posX = tag.m_128459_("PosX");
            double posY = tag.m_128459_("PosY");
            double posZ = tag.m_128459_("PosZ");
            this.m_6034_(posX, posY, posZ);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.35, true));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new DigGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.35, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42581_}), false));
        this.f_21345_.m_25352_(4, (Goal)new SleepGoal(200));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal(this, 1.3, 10.0f, 2.0f, false){

            public boolean m_8036_() {
                return super.m_8036_() && !WeaselEntity.this.m_21825_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, true));
        this.f_21346_.m_25352_(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true));
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_21825_()) {
            this.m_21573_().m_26573_();
            this.m_20242_(false);
        } else {
            this.m_20242_(false);
            this.m_21573_().m_26569_();
        }
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.f_19804_.m_135381_(DIGGING, (Object)digging);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean m_21827_() {
        return this.orderedToSit;
    }

    public void m_21839_(boolean isSitting) {
        this.orderedToSit = isSitting;
    }

    public boolean m_21825_() {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & 1) != 0;
    }

    public void m_21837_(boolean sitting) {
        super.m_21837_(sitting);
        this.orderedToSit = sitting;
        if (sitting) {
            this.m_21573_().m_26573_();
        }
    }

    public static boolean canSpawn(EntityType<WeaselEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<WeaselEntity> event) {
        LivingEntity target = this.m_5448_();
        if (target != null && !target.m_6084_()) {
            this.m_6710_(null);
            target = null;
        }
        if (this.m_5803_()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDigging()) {
            event.getController().setAnimation(RawAnimation.begin().then("dig", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (target instanceof Chicken || target instanceof Rabbit) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private boolean isFollowingPlayerWithFood() {
        Player player = this.m_9236_().m_45930_((Entity)this, 10.0);
        if (player != null) {
            ItemStack heldItem = player.m_21205_();
            return heldItem.m_41720_() == Items.f_42581_;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public WeaselEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob otherParent) {
        WeaselEntity babyWeasel = (WeaselEntity)((EntityType)FaunifyEntities.WEASEL.get()).m_20615_((Level)serverLevel);
        if (babyWeasel != null && otherParent instanceof WeaselEntity) {
            Variant selectedVariant;
            WeaselEntity parent = (WeaselEntity)otherParent;
            boolean thisIsSnowy = this.isSnowVariant();
            boolean parentIsSnowy = parent.isSnowVariant();
            if (thisIsSnowy && parentIsSnowy) {
                babyWeasel.setSnowVariant(true);
                selectedVariant = Variant.STOAT;
            } else if (thisIsSnowy || parentIsSnowy) {
                babyWeasel.setSnowVariant(false);
                selectedVariant = thisIsSnowy ? parent.getVariant() : this.getVariant();
            } else {
                selectedVariant = this.f_19796_.m_188499_() ? this.getVariant() : parent.getVariant();
            }
            babyWeasel.setVariant(selectedVariant);
        }
        return babyWeasel;
    }

    protected SoundEvent m_7515_() {
        int soundIndex = this.f_19796_.m_188503_(3);
        switch (soundIndex) {
            case 0: {
                return (SoundEvent)FaunifySounds.WEASEL_IDLE_1.get();
            }
            case 1: {
                return (SoundEvent)FaunifySounds.WEASEL_IDLE_2.get();
            }
            case 2: {
                return (SoundEvent)FaunifySounds.WEASEL_IDLE_3.get();
            }
        }
        return (SoundEvent)FaunifySounds.WEASEL_IDLE_1.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.WEASEL_HURT.get();
    }

    private void spawnItem(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        this.m_19983_(stack);
    }

    public boolean m_7327_(Entity target) {
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (target instanceof Chicken || target instanceof Rabbit) {
            return super.m_7327_(target);
        }
        if (target instanceof Player && !this.hasBittenPlayer) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.4, 0.0));
            this.m_5496_((SoundEvent)FaunifySounds.WEASEL_BITE.get(), 1.0f, 1.0f);
            this.hasBittenPlayer = true;
            this.m_6710_(null);
            this.m_6703_(null);
            return super.m_7327_(target);
        }
        return flag;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        boolean result = super.m_6469_(source, amount);
        if (this.m_21825_()) {
            double knockbackStrength = 0.05;
            double directionX = this.m_20185_() - source.m_7639_().m_20185_();
            double directionZ = this.m_20189_() - source.m_7639_().m_20189_();
            double length = Math.sqrt(directionX * directionX + directionZ * directionZ);
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3, 0.0));
            this.m_20256_(this.m_20184_().m_82520_(directionX / length * knockbackStrength, 0.0, directionZ / length * knockbackStrength));
            this.m_21837_(false);
        }
        if ((entity = source.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            if (!player.equals((Object)this.m_269323_())) {
                this.m_6710_((LivingEntity)source.m_7639_());
            }
            this.hasBittenPlayer = false;
        }
        return result;
    }

    public boolean isInSnowyBiome() {
        Holder biomeHolder = this.m_9236_().m_204166_(this.m_20183_());
        boolean isSnowy = biomeHolder.m_203656_(Tags.Biomes.IS_SNOWY);
        return isSnowy;
    }

    public boolean isSnowVariant() {
        return this.f_19804_.m_135370_(SNOWY_VARIANT) != null && (Boolean)this.f_19804_.m_135370_(SNOWY_VARIANT) != false;
    }

    public void setSnowVariant(boolean isSnowy) {
        this.f_19804_.m_135381_(SNOWY_VARIANT, (Object)isSnowy);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (this.isDigging()) {
                return InteractionResult.PASS;
            }
            if (item == Items.f_42697_) {
                if (this.m_21223_() < this.m_21233_()) {
                    int particleCount = 5;
                    this.m_5634_(3.0f);
                    for (int i = 0; i < particleCount; ++i) {
                        double offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetY = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        this.m_9236_().m_7106_((ParticleOptions)FaunifyParticleTypes.HEALTH.get(), this.m_20185_() + offsetX, this.m_20186_() + (double)this.m_20192_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
                    }
                } else {
                    this.toggleSittingState();
                }
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42581_) {
                if (!this.m_27593_() && this.m_146764_() == 0) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_27595_(player);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                    }
                } else {
                    this.toggleSittingState();
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_() || item != Items.f_42697_ && item != Items.f_42581_) {
                this.toggleSittingState();
                return InteractionResult.SUCCESS;
            }
        }
        if (item == Items.f_42697_ && !this.m_21824_()) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.m_21816_(player.m_20148_());
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void toggleSittingState() {
        boolean currentSittingState = this.m_21825_();
        this.m_21837_(!currentSittingState);
        if (!this.m_9236_().f_46443_) {
            if (!currentSittingState) {
                this.m_21573_().m_26573_();
            } else {
                this.m_21839_(false);
                this.m_21573_().m_26569_();
            }
        }
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (this.m_21824_() && this.m_269323_() != null && target == this.m_269323_()) {
            return;
        }
        super.m_6710_(target);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42581_;
    }

    public static enum Variant implements StringRepresentable
    {
        STOAT(0, "stoat"),
        STEPPE(1, "steppe"),
        EUROPEAN(2, "european"),
        SIBERIAN(3, "siberian"),
        YELLOWBELLIED(4, "yellowbellied");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int p_262571_, String p_262693_) {
            this.id = p_262571_;
            this.name = p_262693_;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int p_262643_) {
            return BY_ID.apply(p_262643_);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    private class DigGoal
    extends Goal {
        private final WeaselEntity weasel;
        private ItemEntity targetEgg;
        private static final double SEARCH_RADIUS = 5.0;
        private int diggingTime;
        private static final int DIGGING_DURATION = 25;
        private boolean hasPickedUpEgg = false;
        private static final long DIG_COOLDOWN = TimeUnit.MINUTES.toMillis(3L);

        public DigGoal(WeaselEntity weasel) {
            this.weasel = weasel;
        }

        public boolean m_8036_() {
            if (this.weasel.m_21825_()) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.weasel.lastDigTime < DIG_COOLDOWN) {
                return false;
            }
            List nearbyItems = this.weasel.m_9236_().m_6443_(ItemEntity.class, this.weasel.m_20191_().m_82400_(5.0), itemEntity -> itemEntity.m_32055_().m_41720_() == Items.f_42521_);
            if (!nearbyItems.isEmpty()) {
                this.targetEgg = (ItemEntity)nearbyItems.get(0);
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.diggingTime = 0;
            this.hasPickedUpEgg = false;
            this.weasel.m_21573_().m_5624_((Entity)this.targetEgg, 1.0);
        }

        public void m_8037_() {
            BlockPos weaselPos = this.weasel.m_20183_().m_7495_();
            BlockState blockState = this.weasel.m_9236_().m_8055_(weaselPos);
            if (blockState.m_204336_(BlockTags.f_144274_) || blockState.m_60713_(Blocks.f_49994_) || blockState.m_204336_(BlockTags.f_13029_)) {
                if (this.targetEgg != null && (double)this.weasel.m_20270_((Entity)this.targetEgg) < 1.0) {
                    this.targetEgg.m_146870_();
                    if (!this.hasPickedUpEgg) {
                        this.weasel.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                        this.hasPickedUpEgg = true;
                    }
                    if (this.diggingTime == 0) {
                        this.weasel.m_21573_().m_26573_();
                        this.weasel.setDigging(true);
                    }
                    ++this.diggingTime;
                    Level level = this.weasel.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        double d0 = WeaselEntity.this.f_19796_.m_188583_() * 0.01;
                        double d1 = WeaselEntity.this.f_19796_.m_188583_() * 0.01;
                        double d2 = WeaselEntity.this.f_19796_.m_188583_() * 0.01;
                        double offsetX = -Math.sin(Math.toRadians(this.weasel.m_146908_())) * 0.5;
                        double offsetZ = Math.cos(Math.toRadians(this.weasel.m_146908_())) * 0.5;
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), this.weasel.m_20185_() + offsetX, this.weasel.m_20186_(), this.weasel.m_20189_() + offsetZ, 2, d0, d1, d2, 0.1);
                        this.weasel.m_5496_(SoundEvents.f_11993_, 0.5f, 1.0f);
                    }
                    this.weasel.m_20242_(true);
                    this.weasel.m_20334_(0.0, 0.0, 0.0);
                    if (this.diggingTime >= 25) {
                        this.dropRandomLoot();
                        this.weasel.lastDigTime = System.currentTimeMillis();
                        this.targetEgg = null;
                        this.weasel.m_20242_(false);
                        this.weasel.setDigging(false);
                    }
                } else if (this.targetEgg != null) {
                    this.weasel.m_21573_().m_5624_((Entity)this.targetEgg, 1.0);
                }
            }
        }

        public boolean m_8045_() {
            if (this.weasel.m_21825_()) {
                return false;
            }
            return this.targetEgg != null;
        }

        private void dropRandomLoot() {
            this.weasel.m_5496_(SoundEvents.f_11993_, 1.0f, 1.0f);
            RandomSource random = this.weasel.m_217043_();
            if (random.m_188503_(100) < 1) {
                this.weasel.spawnItem(Items.f_42656_);
            } else {
                int dropType = random.m_188503_(6);
                switch (dropType) {
                    case 0: {
                        this.weasel.spawnItem(Items.f_151050_);
                        break;
                    }
                    case 1: {
                        this.weasel.spawnItem(Items.f_42413_);
                        break;
                    }
                    case 2: {
                        this.weasel.spawnItem(Items.f_42500_);
                        break;
                    }
                    case 3: {
                        this.weasel.spawnItem(Items.f_42577_);
                        break;
                    }
                    case 4: {
                        this.weasel.spawnItem(Items.f_42733_);
                        break;
                    }
                    case 5: {
                        this.weasel.spawnItem(Items.f_42404_);
                    }
                }
            }
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = WeaselEntity.this.f_19796_.m_188503_(SleepGoal.m_186073_((int)countdownTime));
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (WeaselEntity.this.f_20900_ == 0.0f && WeaselEntity.this.f_20901_ == 0.0f && WeaselEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || WeaselEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return WeaselEntity.this.m_9236_().m_46462_();
        }

        public void m_8041_() {
            WeaselEntity.this.setSleeping(false);
            this.countdown = WeaselEntity.this.f_19796_.m_188503_(this.countdownTime);
        }

        public void m_8056_() {
            WeaselEntity.this.m_21837_(false);
            WeaselEntity.this.m_6862_(false);
            WeaselEntity.this.setSleeping(true);
            WeaselEntity.this.m_21573_().m_26573_();
            WeaselEntity.this.m_21566_().m_6849_(WeaselEntity.this.m_20185_(), WeaselEntity.this.m_20186_(), WeaselEntity.this.m_20189_(), 0.0);
        }
    }
}

